"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../config/database"));
class Subscription extends sequelize_1.Model {
}
Subscription.init({
    id: {
        type: sequelize_1.DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
    },
    stripeSubscriptionId: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
        // unique: true,
    },
    stripeCustomerId: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    stripePaymentMethodId: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    planId: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
        // autoIncrement: true,
    },
    status: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    currentPeriodEnd: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
    },
    userId: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: 'Users',
            key: 'id',
        },
    },
}, {
    sequelize: database_1.default,
    modelName: 'Subscription',
    tableName: "subscriptions",
});
exports.default = Subscription;
