"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../config/database"));
class WebhookEndpoint extends sequelize_1.Model {
}
WebhookEndpoint.init({
    webhook_id: {
        type: sequelize_1.DataTypes.UUID,
        defaultValue: sequelize_1.DataTypes.UUIDV4,
        primaryKey: true,
    },
    organization_id: {
        type: sequelize_1.DataTypes.UUID,
        allowNull: false,
        references: {
            model: 'Organization',
            key: 'organization_id',
        },
    },
    url: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    secret_key: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    subscribed_event_types: {
        type: sequelize_1.DataTypes.JSON,
        allowNull: false,
        defaultValue: [],
    },
    status: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
        defaultValue: 'active',
    },
    last_successful_delivery_at: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: true,
    },
    last_failed_delivery_at: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: true,
    },
    created_at: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updated_at: {
        type: sequelize_1.DataTypes.DATE,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: database_1.default,
    modelName: 'WebhookEndpoint',
    tableName: 'WebhookEndpoints',
    timestamps: false,
    underscored: true,
});
exports.default = WebhookEndpoint;
