"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.asyncHandler = void 0;
// import asyncHandler from 'express-async-handler';
const asyncHandler = (fn) => {
    return (req, res, next) => {
        Promise.resolve(fn(req, res, next)).catch(() => {
            if (!res.headersSent) {
                res.status(500).send("Server error");
            }
        });
    };
};
exports.asyncHandler = asyncHandler;
