"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const database_1 = __importDefault(require("../../config/database"));
class Organization extends sequelize_1.Model {
}
Organization.init({
    organization_id: {
        type: sequelize_1.DataTypes.UUID,
        primaryKey: true,
        unique: true,
        allowNull: false,
    },
    name: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
        unique: true,
    },
    owner_user_id: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: 'Users',
            key: 'id',
        },
    },
    subscription_plan_id: {
        type: sequelize_1.DataTypes.INTEGER,
        allowNull: true,
        references: {
            model: 'subscriptions',
            key: 'id',
        },
    },
    billing_contact_email: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    vapi_api_key_encrypted: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    custom_features_flags: {
        type: sequelize_1.DataTypes.JSON,
        allowNull: false,
        defaultValue: {},
    },
    status: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: false,
    },
    organization_size: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    industry_type: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    assistant_name: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    assistant_task_description: {
        type: sequelize_1.DataTypes.TEXT,
        allowNull: true,
    },
    preferred_language: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    contact_phone_number: {
        type: sequelize_1.DataTypes.STRING,
        allowNull: true,
    },
    created_at: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
    updated_at: {
        type: sequelize_1.DataTypes.DATE,
        allowNull: false,
        defaultValue: sequelize_1.DataTypes.NOW,
    },
}, {
    sequelize: database_1.default,
    modelName: 'Organization',
    tableName: 'Organization',
    timestamps: false,
    underscored: true,
});
exports.default = Organization;
