"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const assistantConfigcontroller_1 = require("../controllers/assistantConfigcontroller");
const isAuth_1 = __importDefault(require("../middleware/isAuth"));
const router = express_1.default.Router();
// 📥 CREATE
router.post('/', isAuth_1.default, assistantConfigcontroller_1.createAssistantConfig);
// 📤 READ
router.get('/', isAuth_1.default, assistantConfigcontroller_1.getAllAssistantConfigs);
router.get('/:id', assistantConfigcontroller_1.getAssistantConfigById);
// ✏️ UPDATE
router.put('/:id', assistantConfigcontroller_1.updateAssistantConfig);
// ❌ DELETE
router.delete('/:id', assistantConfigcontroller_1.deleteAssistantConfig);
exports.default = router;
