"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const app_1 = __importDefault(require("./app"));
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const https_1 = __importDefault(require("https"));
const options = {
    key: fs_1.default.readFileSync(path_1.default.join(__dirname, 'key.pem')),
    cert: fs_1.default.readFileSync(path_1.default.join(__dirname, 'cert.pem')),
    ca: fs_1.default.readFileSync(path_1.default.join(__dirname, 'chain.crt'))
};
const port = Number(process.env.PORT) || 3000;
const server = https_1.default.createServer(options, app_1.default);
server.listen(port, () => {
    console.log(`Server running on port ${port}`);
});
